﻿Imports System.Xml
Public Class Form1
    Private Sub Form1_Load(ByVal sender As System.Object, _
            ByVal e As System.EventArgs) Handles MyBase.Load
        'Skąd ma pochodzić plik XML?
        Dim filename As String = _
            "C:\Users\Bryan\Documents\Visual Studio 10\Projects\Address Book\bin\Debug\AddressBook.xml"
        'Otwieranie dokumentu.
        Dim reader As New XmlTextReader(filename)
        'Przejście do początku dokumentu.
        reader.MoveToContent()
        'Początek przechodzenia przez dokument.

        Dim addressData As Collection = Nothing
        Dim elementName As String = Nothing
        Do While reader.Read
            'Jaki jest rodzaj węzła?
            Select Case reader.NodeType
                'Czy jest to początek elementu?
                Case XmlNodeType.Element
                    'Jeśli jest to początek elementu, czy jest to "Address"?
                    If reader.Name = "Address" Then
                        'Jeśli tak, należy utworzyć nową kolekcję.
                        addressData = New Collection()
                    Else
                        'Jeśli nie, należy zapisać nazwę elementu.
                        elementName = reader.Name
                    End If
                    'Jeśli został zapisany tekst, próba zapisania go 
                    'w kolekcji.
                Case XmlNodeType.Text
                    'Czy adres już istnieje?
                    If Not addressData Is Nothing Then
                        addressData.Add(reader.Value, elementName)
                    End If
                    'Czy jest to koniec elementu?
                Case XmlNodeType.EndElement
                    'Jeśli tak, cały adres powinien być już zapisany.
                    If reader.Name = "Address" Then
                        'Próba utworzenia nowego elementu ListView.
                        Dim item As String = Nothing
                        Try
                            item = addressData("firstname") & _
                                   " " & addressData("lastname")
                            item &= " (" & addressData("email") & ")"
                        Catch
                        End Try
                        'Dodawanie elementu do listy.
                        lstEmails.Items.Add(item)
                        'Czyszczenie.
                        addressData = Nothing
                    End If
            End Select
        Loop
    End Sub
End Class
